﻿namespace Microsoft.Samples.PlanMyNight.Web.Infrastructure
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition.Hosting;
    using System.Globalization;
    using System.Linq;
    using System.Web;
    using System.Web.Mvc;
    using System.Web.Routing;

    public class MefControllerFactory : DefaultControllerFactory
    {
        private const string ControllerExportEntryName = "controllerExport";

        private readonly CompositionContainer container;

        public MefControllerFactory(CompositionContainer container)
        {
            this.container = container;
        }

        public override IController CreateController(RequestContext requestContext, string controllerName)
        {
            if (requestContext == null)
            {
                throw new ArgumentNullException("requestContext");
            }

            if (String.IsNullOrEmpty(controllerName))
            {
                throw new ArgumentException("controllerName cannot be empty.", "controllerName");
            }

            // default app controllers
            Type controllerType = this.GetControllerType(requestContext, controllerName);
            if (controllerType != null)
            {
                return this.GetControllerInstance(requestContext, controllerType);
            }

            // addin controllers

            // TODO: Filter using namespace (if found)
            IEnumerable<string> namespaces = GetNamespaceFromRoute(requestContext);

            var controllerExport = this.container.GetExports<IController>(controllerName).FirstOrDefault();
            if (controllerExport == null)
            {
                throw new HttpException(
                    404,
                    string.Format(CultureInfo.InvariantCulture, "The controller for path '{0}' was not found or does not implement IController.", requestContext.HttpContext.Request.Path));
            }

            requestContext.HttpContext.Items[ControllerExportEntryName] = controllerExport;
            return controllerExport.Value;
        }

        public override void ReleaseController(IController controller)
        {
            var export = HttpContext.Current.Items[ControllerExportEntryName] as Lazy<IController>;
            if (export != null)
            {
                this.container.ReleaseExport(export);
            }

            base.ReleaseController(controller);
        }

        private static IEnumerable<string> GetNamespaceFromRoute(RequestContext requestContext)
        {
            object routeNamespacesObj;

            if (requestContext != null &&
                requestContext.RouteData.DataTokens.TryGetValue("Namespaces", out routeNamespacesObj))
            {
                return routeNamespacesObj as IEnumerable<string>;
            }

            return null;
        }
    }
}
